# Дашборды метрик QHB для Grafana

## Общее описание

QHB поставляется совместно с сервером метрик, который записывает данные метрик в Graphite и интерфейсом к которым служит Grafana. Текущий набор дашбордов для Grafana поставляется в качестве самодокументируемых образцов, на основе которых пользователи, при необходимости, могут самостоятельно создать дашборда, более соответствующие их потребностям. Вместе с тем, поставляемые дашборды могут использоваться и в исходном виде.  

Описание метрик QHB приведено по адресу: https://repo.granit-concern.ru/qhb/std-1/doc/Configuration/monitoring.html#%D0%9C%D0%B5%D1%82%D1%80%D0%B8%D0%BA%D0%B8-qhb. Список метрик пополняется с каждым релизом.

## Импорт дашбордов

Экспорт JSON-описания дашбордов выполнен в Grafana 6.7.2.  

Перед импортом JSON-описания необходимо решить, будут ли названия метрик содержали в качестве префикса имя хоста. Именно таким образом устроены наименования метрик внутри дашбордов и этот вариант рекомендуется оставить. В начале имен метрик добавлена переменная $server_name, по умолчанию для нее выбрано значение `your_host_name`. Перед импортом можно заменить в JSON-файлах это значение на наименование одного из хостов. В дальнейшем в этой переменной через интерфейс Grafana можно будет добавить через запятую все имена хостов, с которых будут собираться метрики. Это позволит быстро переключаться при просмотре метрик с одного хоста на другой.   
Если такая схема использоваться не будет (в случае, если метрики будут использоваться с единственного хоста), можно удалить в файлах JSON во всех именах метрик префикс $server_name до проведения импорта описания JSON. Однако, это более трудоемкий вариант и его выбирать не рекомендуется.

Для импорта описаний дашбордов необходимо выполнить следующие шаги:  
1) В меню "Dashboards" вашего сайта Grafana выбрать пункт "Manage".  
2) В открывшемся списке папок и дашбордов выбрать существующую или создать новую папку.  
3) Находясь в выбранной папке, выбрать в правой верхней части страницы пункт "Import".  
4) На открывшейся странице можно либо нажать справа вверху кнопку "Upload .json file" и загрузить файл либо вставить содержание JSON-файла в поле под заголовком "Or paste JSON" и нажать кнопку "Load". После этого нужно заполнить необходимые параметры и выполнить загрузку JSON-описания. 

## Краткое описание дашбордов
### Дашборд "Операционная система"
Дашборд представляет основные системные показатели:
 - Время работы инстанаса QHB
 - Load Average
 - Исполользование CPU
 - Использование памяти
 - Использование дисковой системы, на которой расположен каталог баз данных

### Дашборд "QHB"
Дашборд содержит несколько разделов:
 - Транзакции
 - Чтение и запись блоков
 - События ожидания (основные)
 - События ожиданий (вспомогательные)
 - Временные таблицы и файлы
 - Контрольные точки и операции с буферами
 - Архивация WAL
 - QCP
 - TARQ
В каждом разделе представлены наборы тематических панелей, отражающие основные показатели. 

## Настройка сбора метрик
Для того, чтобы дашборды отображали данные метрик, необходимо выполнить некоторые настройки.

### Настройка сервера метрик
Документация по настройке сервера метрик доступна по адресу https://repo.granit-concern.ru/qhb/std-1/doc/Internal/metricsd.html.  
Рекомендуется в параметре `prefix` конфига `/etc/metricsd/config.yaml` сервера метрик прописать имя хоста, на котором он работает. Если сделать это для каждого сервера, все метрики будут организованы иерархически, и первый уровень иерархии будет уровнем серверов. В именах метрик в предлагаемых дашбордах для этих целей присутствует переменная $server_name. Подразумевается, что на хосте работает только один кластер баз данных.

### Настройка параметров базы данных
Для настройки отправки метрик необходимо в qhb.conf  указать параметр `metrics_collector_id` в значение, с которым запускается сборщик метрик, например, 1001 (актуально до релиза 1.3.0).
Начиная с релиза 1.3.0 параметр `metrics_collector_id` нужно убрать и вместо него прописать параметр `metrics_collector_path` со значением по умолчанию `@metrics-collector` (представляет собой адрес unix domain socket'а), сервер метрик по умолчанию запускается именно на этом адресе.
Значение для варианта с базой вне докера и инфраструктурой метрик в докере: `/var/run/metricsd/metrics-collector.sock`, т.к. в docker-compose.yaml по умолчанию в секции metricsd прописаны параметры
```
    command: "/tmp/metrics-collector.sock"
    volumes:
      - /var/run/metricsd/:/tmp 
```

Для настройки отправки аннотаций необходимо в qhb.conf прописать следующие параметры:  
grafana.address - адрес Графаны, например http://localhost:3000  
grafana.token - необходимо указать токен, полученный в Графане по адресу http://localhost:3000/org/apikeys  

Пример настроек в qhb.conf для отправки метрик и аннотаций
```
# До релиза 1.3.0
# metrics_collector_id = 1001  

# С релиза 1.3.0 с инфраструктурой сбора метрик вне докера:
metrics_collector_path = '@metrics-collector'

grafana.address = 'http://localhost:3000'
grafana.token = 'eyJrIjoiNGxTaloxMUNTQkFUMTN0blZqUTN6REN6OWI5YjM1MzMiLCJuIjoidGVzdCIsImlkIjoxfQ=='
```

Для сбора системных метрик (Дашборд "Операционная система") необходимо установить параметр `qhb_os_monitoring` в значение `on`. Можно также задать период сбора системной статистики `qhb_os_stat_period`, значение по умолчанию которого равно 30 секундам. Не рекомендуется задавать слишком низкое значение для этого параметра, т.к. сбор системной статистики требует некоторых ресурсов. 

В файле параметров можно прописать:
```
qhb_os_monitoring = on
qhb_os_stat_period = 60 # если период по умолчанию в 30 секунд не устраивает
```
Либо выполнить команды:
```
alter system set qhb_os_monitoring = on;
alter system set qhb_os_stat_period = 60;
select pg_reload_conf();
```

## Примеры использования метрик в SQL-функциях
Помимо встроенных метрик, пользователи могут использовать свои метрики через следующие функции SQL.

### Тип метрик Timer
Используется при фиксации промежутка времени, единицы измерения - наносекунды.
```
select qhb_timer_report('qhb.timer.nano',10000000000 /* 10 секунд в наносекундах */);  
```

### Тип метрик Counter
Используется, когда нужно зафискировать количество произошедших за промежуток времени событий.
```
select qhb_counter_increase_by('qhb.example.counter',10);  
```

### Тип метрик Gauge
Используется, когда нужно установить некий статичный показатель в определенное значение или изменить его. 
```
select qhb_gauge_update('qhb.gauge_example.value', 10); /* Установка значения */  
select qhb_gauge_add('qhb.gauge_example.value',1); /* Увеличение значения */  
select qhb_gauge_sub('qhb.gauge_example.value',1); /* Уменьшение значения */  
```

### Аннотации
Используются, если нужно добавить комментарий к данным метрик.
Первый параметр функции - текст комментария, последующие параметры - теги.
```
select qhb_annotation('Начало выполнения теста', 'test','billing'); /* Текст аннотации и два тега */  
```

Для отображения аннотаций с заданными тегами нужно привести соответствующие теги в настройках аннотаций дашбордов на стороне "Графаны".  
Для этого через меню  "Dashboard Settings" -> "Annotations" заполняются настройки, где в качестве источника данных выбирается "--Graphana--", 
а поле "Tags" заполняется сответствующими значениями.



